#include <windows.h>
#include "pe.h"


IMAGE_SECTION_HEADER*
         PEfileDirectoryEntryToSectionHeader( void* File, int Entry )
  {
    IMAGE_OPTIONAL_HEADER  *oh;

    if( Entry < 0 || Entry >= IMAGE_NUMBEROF_DIRECTORY_ENTRIES ) return NULL;
    oh = (IMAGE_OPTIONAL_HEADER*) OPTHDROFFSET( File );
    return PEfileVAToSectionHeader( File,
                                oh->DataDirectory[ Entry ].VirtualAddress );
  }

IMAGE_SECTION_HEADER* PEfileVAToSectionHeader( void* File, DWORD VA )
  {
    return ImageRvaToSection( ImageNtHeader( File ), File, VA );

    /*
    IMAGE_SECTION_HEADER   *sh;
    DWORD  scount, i;

    // scanning sections

    scount = ((IMAGE_FILE_HEADER*) PEFHDROFFSET( File ))->NumberOfSections;
    sh = (IMAGE_SECTION_HEADER*) SECHDROFFSET( File );
    for( i = 0; i < scount; i++, sh++ )
      if( VA >= sh->VirtualAddress &&
          VA < sh->VirtualAddress + sh->SizeOfRawData ) return sh;
    return NULL;
    */
  }

IMAGE_SECTION_HEADER* PEfileGetCodeSectionHeader( void* File )
  {
    IMAGE_SECTION_HEADER   *sh;
    DWORD  scount, i;

    scount = ((IMAGE_FILE_HEADER*) PEFHDROFFSET( File ))->NumberOfSections;
    sh = (IMAGE_SECTION_HEADER*) SECHDROFFSET( File );
    for( i = 0; i < scount; i++, sh++ )
      if( sh->Characteristics & IMAGE_SCN_CNT_CODE ) return sh;
    return NULL;
  }

void* PEimageGetEntryPoint( void* Image )
  {
    return (void*) (((BYTE*) Image) +
                    ((IMAGE_OPTIONAL_HEADER*)
                        OPTHDROFFSET( File ))->AddressOfEntryPoint);
  }

FARPROC PEimageProcAddress( void* Image, char* ProcName )
  {
    IMAGE_OPTIONAL_HEADER  *oh;
    IMAGE_EXPORT_DIRECTORY *ExpDir;
    DWORD    i, fcount;
    USHORT   ord;
    USHORT   *Ords;
    DWORD    *Names, *Addrs;

    oh = (IMAGE_OPTIONAL_HEADER*) OPTHDROFFSET( Image );
    ExpDir = (IMAGE_EXPORT_DIRECTORY*)(((BYTE*) Image) +
             oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_EXPORT ].VirtualAddress);
    if( ExpDir == NULL ) return NULL;
    }
    fcount = ExpDir->NumberOfNames;
    Addrs = (DWORD*) (((BYTE*) Image) + (DWORD)(ExpDir->AddressOfFunctions));
    Names = (DWORD*) (((BYTE*) Image) + (DWORD)(ExpDir->AddressOfNames));
    Ords = (USHORT*) (((BYTE*) Image) + (DWORD)(ExpDir->AddressOfNameOrdinals));
    if( ((DWORD) Image) & 0xFFFF0000 ) {

      // by name

      for( i = 0; i < fcount; i++ )
        if( lstrcmp( ProcName, ((char*) Image) + *(Names + i) ) == 0 )
          return (FARPROC) (((char*) Image) + *(Addrs + i));
    }
    else {

      // by ordinal

      ord = (USHORT)((DWORD) Image);
      if( ord == 0 || ord >= fcount ) return NULL;
      for( i = 0; i < fcount; i++ )
        if( ord == *(Ords + i) )
          return (FARPROC) (((char*) Image) + *(Addrs + i));
    }
    return NULL;
  }

void* PEGetResource( void* p, BOOL IsFile,
                     WORD ResType, WORD ResId, DWORD* ResourceSize )
  {
    IMAGE_OPTIONAL_HEADER     *oh;
    IMAGE_SECTION_HEADER      *sh;
    IMAGE_RESOURCE_DIRECTORY  *rd;
    IMAGE_RESOURCE_DIRECTORY_ENTRY   *rde;
    IMAGE_RESOURCE_DATA_ENTRY        *rdata;
    DWORD  raddr, rsize, scount, i, rsrcVA;
    BYTE   *rsec, *RetVal;

    // get optional header ptr

    oh = (IMAGE_OPTIONAL_HEADER*) OPTHDROFFSET( p );
    raddr = oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_RESOURCE ].VirtualAddress;
    rsrcVA = raddr;
    rsize = oh->DataDirectory[ IMAGE_DIRECTORY_ENTRY_RESOURCE ].Size;

    if( IsFile ) {
      sh = PEfileVAToSectionHeader( p, raddr );
      if( sh != NULL ) raddr = sh->PointerToRawData;
    }
    if( raddr == 0 || rsize == 0 ) return NULL;

    rsec = ((char*) p) + raddr;

    // scan root level of resource tree for type

    rd = (IMAGE_RESOURCE_DIRECTORY*) rsec;
    rde = (IMAGE_RESOURCE_DIRECTORY_ENTRY*) (rd + 1);
    for( rsize = 0; rsize < rd->NumberOfIdEntries; rsize++, rde++ ) {
      if( ResType == rde->NameOffset ) break;
    }
    if( rsize >= rd->NumberOfIdEntries ) return NULL;

    // rde is now pointer to the type entry

    if( ! rde->DataIsDirectory ) return NULL;
    rd = (IMAGE_RESOURCE_DIRECTORY*) (rsec + rde->OffsetToDirectory);

    // scan second level of resource tree for id

    rde = (IMAGE_RESOURCE_DIRECTORY_ENTRY*) (rd + 1);
    for( rsize = 0; rsize < rd->NumberOfIdEntries; rsize++, rde++ ) {
      if( ResId == rde->NameOffset ) break;
    }
    if( rsize >= rd->NumberOfIdEntries ) return NULL;

    // rde is now pointer to appropriate id entry

    if( rde->DataIsDirectory ) {

      // if entry doesn't points to resource data immediately,
      // get resource data from the third level of resource tree

      rd = (IMAGE_RESOURCE_DIRECTORY*) (rsec + rde->OffsetToDirectory);
      rde = (IMAGE_RESOURCE_DIRECTORY_ENTRY*) (rd + 1);
      if( rd->NumberOfIdEntries < 1 ) return NULL;
    }

    // here rde is the pointer to resource data entry

    if( rde->DataIsDirectory ) return NULL;

    rdata = (IMAGE_RESOURCE_DATA_ENTRY*) (rsec + rde->OffsetToDirectory);
    if( ResourceSize != NULL ) *ResourceSize = rdata->Size;

    if( IsFile ) RetVal = rsec + (rdata->OffsetToData - rsrcVA);
    else RetVal = p + rdata->OffsetToData;

    return (void*) RetVal;
  }
